# RedisStorage
## Описание
Предоставляет интерфейс сохранения данных в Redis

### Важно
Хранение

## Пример использования
```python
from pydantic import BaseModel
from typing import Optional

class UserModel(BaseModel):
    name: str
    age: int

from blackbot_redis_storage import RedisStorage, ObjectStorageUnit

class UserRedisStorage(RedisStorage):
    # Определяем хранилище пользователей с использованием ObjectStorageUnit
    users = ObjectStorageUnit[UserModel](prefix='users', model=UserModel, expire=3600)

# Инициализируем подключение к Redis
storage = UserRedisStorage(
    redis_host="localhost",
    redis_port=6379,
    redis_password="xxx",
    redis_db=0,
    default_expire=3600
)

# Устанавливаем значение
user1 = UserModel(name='John Doe', age=30)
storage.users[1] = user1

# Получаем значение
print(storage.users.get(1).json())
print(storage.users[1].json())

# Обновляем значение
user1.age = 31
storage.users.update(1, user1)  # ключ, значение
storage.users.update_some_key(1, "name", "John Smith")  # ключ, поле, значение
storage.users.update_many_keys(
    1,  # ID
    {
        "age": 32,
        "name": "John Smith"
    }  # Значения
)
user1 = storage.users[1]

# Удаляем значение
storage.users.remove(1)

# Исключения
from blackbot_redis_storage import exceptions as redis_storage_exps
try:
    storage.users.update(1, user1)
    # Или
    storage.users.update_some_key(1, "name", "Jane Doe")
except redis_storage_exps.NotFoundException as e:
    print(f"User with ID: {1} not found")
    # Потому что мы удалили этого пользователя на предыдущем шаге
except redis_storage_exps.ConnectionError as e:
    print(f"Cannot connect to Redis...")

class InvalidUserModel:
    name: str

invalidUser = InvalidUserModel(name="Alexa")
try:
    storage.users[1] = invalidUser
except redis_storage_exps.TypeValueError as e:
    print(e)
    # > Значение должно быть подклассом pydantic.BaseModel
```


