from __future__ import annotations

# redis_storage/storage.py
import redis
from typing import get_args, get_origin
from .collections import ModelCollection, Collection

class BaseRedisStorage:
    def __init__(self, redis_host, redis_port, redis_password=None, redis_db=0, default_expire=None):
        self._redis_host = redis_host
        self._redis_port = redis_port
        self._redis_password = redis_password
        self._redis_db = redis_db
        self._default_expire = default_expire

        self._redis_client = redis.Redis(
            host=self._redis_host,
            port=self._redis_port,
            password=self._redis_password,
            db=self._redis_db,
            decode_responses=False  # получаем bytes, пусть поля сами разбираются
        )

        for name, type_hint in self.__class__.__annotations__.items():
            if get_origin(type_hint) is Collection:
                model_cls, key_type = get_args(type_hint)
                
                prefix = getattr(model_cls.Config, "key_prefix", name)
                expire = getattr(model_cls.Config, "default_expire", default_expire)
                
                collection_instance = ModelCollection(
                    self._redis_client, model_cls, key_type, prefix, expire
                )
                setattr(self, name, collection_instance)
